import { Link, useLocation } from 'react-router-dom'
import { Sparkles } from 'lucide-react'
import Footer from './Footer'
import './Layout.css'

const Layout = ({ children }) => {
  const location = useLocation()

  return (
    <>
      <header className="header">
        <div className="container">
          <div className="header-content">
            <Link to="/" className="logo">
              <Sparkles size={28} strokeWidth={2} className="logo-icon" />
              <span className="logo-text">WellnessHub</span>
            </Link>
            <nav className="nav">
              <Link 
                to="/" 
                className={`nav-link ${location.pathname === '/' ? 'active' : ''}`}
              >
                Мои посещения
              </Link>
              <Link 
                to="/book" 
                className={`nav-link ${location.pathname === '/book' ? 'active' : ''}`}
              >
                Записаться
              </Link>
            </nav>
          </div>
        </div>
      </header>
      <main>{children}</main>
      <Footer />
    </>
  )
}

export default Layout

